<?php
// routes/web.php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebSocketController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PriceController;

Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
Route::get('/api/devices', [WebSocketController::class, 'getDevices']);
Route::post('/api/disconnect/{device_id}', [WebSocketController::class, 'disconnectDevice']);
Route::post('/api/command/{device_id}', [WebSocketController::class, 'sendCommand']);
Route::get('/api/receipts/{device_id}', [WebSocketController::class, 'getReceipts']);
Route::get('/api/tank-info/{device_id}', [WebSocketController::class, 'getTankInfo']);
Route::get('/api/prices/{device_id}', [WebSocketController::class, 'getPrices']);
Route::post('/api/prices/{device_id}', [WebSocketController::class, 'updatePrices']);
Route::get('/api/pts/{device_id}/status', [WebSocketController::class, 'getPtsStatus']);
Route::post('/api/pts/{device_id}/shift', [WebSocketController::class, 'manageShift']);
Route::post('/api/pts/{device_id}/pump-control', [WebSocketController::class, 'controlPump']);
Route::get('/api/pts/{device_id}/daily-report', [WebSocketController::class, 'getDailyReport']);

Route::get('/prices', [PriceController::class, 'index'])->name('prices');