<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class FuelPriceController extends Controller
{
    public function index()
    {
        $currentP91 = 3.45;
        $currentP95 = 3.75;
        $currentDiesel = 2.95;

        return view('fuel-prices', compact('currentP91', 'currentP95', 'currentDiesel'));
    }

    public function updatePrices(Request $request)
    {
        try {
            $data = [
                "Protocol" => "jsonPTS",
                "Packets" => [[
                    "Id" => 1,
                    "Type" => "SetFuelGradesConfiguration",
                    "Data" => [
                        "FuelGrades" => [
                            [
                                "Id" => 1,
                                "Name" => "P91",
                                "Price" => floatval($request->p91)
                            ],
                            [
                                "Id" => 2,
                                "Name" => "P95",
                                "Price" => floatval($request->p95)
                            ],
                            [
                                "Id" => 3,
                                "Name" => "Diesel",
                                "Price" => floatval($request->diesel)
                            ]
                        ]
                    ]
                ]]
            ];

            Log::info('Updating fuel prices', $data);
            
            return response()->json(['success' => true, 'message' => 'تم تحديث الأسعار بنجاح']);
        } catch (\Exception $e) {
            Log::error('Failed to update fuel prices: ' . $e->getMessage());
            return response()->json(['success' => false, 'message' => 'فشل تحديث الأسعار'], 500);
        }
    }
}